<?php get_header(); ?>
<main>
    <div class="wrapper_main">
        <div class="container">
            <div class="wrapper_content">
                <div class="title_wrapper">
                    <div>
                        <div class="icon_title">
                            <?php include locate_template('assets/img/icon-title-9.svg'); ?>
                        </div>
                        <h2 class="title"><?php the_title() ?></h2>
                    </div>
                    <?php get_template_part('template-parts/back', 'button') ?>
                </div>
                <div class="wrapper_inner">
                    <div class="content_box">
                        <div class="news_box_wrapper">
                            <?php
                            global $wp_query, $paged;
                            $wp_query = new WP_Query([
                                'post_type' => 'post',
                                'posts_per_page' => 7,
                                'paged' => $paged,
                            ]);
                            if ($wp_query->have_posts()) {
                                while ($wp_query->have_posts()) {
                                    $wp_query->the_post();
                                    get_template_part('template-parts/loop/news');
                                }
                            ?>
                                <div class="pagination_wrapper">
                                    <div class="pagination">
                                        <?php
                                        echo paginate_links(
                                            [
                                                'end_size' => 3,
                                                'prev_next' => false,
                                            ]
                                        );
                                        ?>
                                        <!-- <a href="#"><?php //include 'img/pagination-arrow.svg'; ?></a>
                                        <a href="#" class="active">1</a>
                                        <a href="#">2</a>
                                        <a href="#">3</a>
                                        <a href="#" class="pagination_dots">...</a>
                                        <a href="#">7</a>
                                        <a href="#">8</a>
                                        <a href="#">9</a>
                                        <a href="#"><?php //include 'img/pagination-arrow.svg'; ?></a> -->
                                    </div>
                                </div>
                            <?php
                            }
                            wp_reset_query();
                            ?>
                        </div>
                    </div>
                    <?php get_sidebar() ?>
                </div>
            </div>
        </div>
    </div>
</main>
<?php
get_footer();
